
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using System.Data.SqlTypes;
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{
	[TestFixture]
	public class DAL_Reagent : BaseTest 
	{
		
		private DataTable _dtReagent;
		private DataTable _dtRack;

		private System.DateTime _minDate = SqlDateTime.MinValue.Value.Date;
		private System.DateTime _maxDate = SqlDateTime.MaxValue.Value.Date;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtReagent = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Reagent WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'", true);

				//***********Rack 
				this._dtRack = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Rack WHERE RackGuid IN (SELECT RackGuid FROM RackLot WHERE RackGuid IS NOT NULL AND ReagentGuid IN (SELECT ReagentGuid FROM Reagent WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'))", true);

				this.RefreshData = false;
			}
		}

		[Test]
		public void GetReagents_Pass()
		{
			DataTable dtTest = DAL.Reagent.GetReagents(this.TestDivisionCode, this._maxDate, this._minDate, this._maxDate, this._minDate);
			DataTable dtTest2 = DAL.Reagent.GetReagents(this.TestDivisionCode, System.DateTime.MaxValue, System.DateTime.MinValue, System.DateTime.MaxValue, System.DateTime.MinValue);

			Assert.AreEqual(dtTest.Rows.Count, dtTest2.Rows.Count, "Rows.Count");
			Assert.AreEqual(17, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentGuid), TABLES.Reagent.ReagentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentTypeId), TABLES.Reagent.ReagentTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentName), TABLES.Reagent.ReagentName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReceiptDate), TABLES.Reagent.ReceiptDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReceiptTechId), TABLES.Reagent.ReceiptTechId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.InvoiceNumber), TABLES.Reagent.InvoiceNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotNumber), TABLES.Reagent.LotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotExpirationDate), TABLES.Reagent.LotExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.InspectionIndicator), TABLES.Reagent.InspectionIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.NumberVialsAvailable), TABLES.Reagent.NumberVialsAvailable);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.NumberVialsReceived), TABLES.Reagent.NumberVialsReceived);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.Comments), TABLES.Reagent.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeName), TABLES.ReagentType.ReagentTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.SortColumn), TABLES.ReagentType.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTypeParameter.MinimumStockLevel), TABLES.ReagentTypeParameter.MinimumStockLevel);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentManufacturerName), TABLES.Reagent.ReagentManufacturerName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.RowVersion), TABLES.Reagent.RowVersion);
		}

		[Test]
		public void GetReagents_Fail()
		{
			DataTable dtTest = DAL.Reagent.GetReagents(string.Empty, this._maxDate, this._minDate, this._maxDate, this._minDate);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetManufacturerReagentNames_Pass()
		{
			string manufacturerName = this._dtReagent.Rows[0][TABLES.Reagent.ReagentManufacturerName].ToString();

			DataTable dtTest = DAL.Reagent.GetManufacturerReagentNames(manufacturerName);

			Assert.AreEqual(2, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentName), TABLES.Reagent.ReagentName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentGuid), TABLES.Reagent.ReagentGuid);
		}

		[Test]
		public void GetManufacturerReagentNames_Fail()
		{
			DataTable dtTest = DAL.Reagent.GetManufacturerReagentNames(string.Empty);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}


		[Test]
		public void InsertReagents_Pass()
		{
			this.RefreshData = true;

			DataTable dtTypes = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM ReagentType", true);

			System.Guid reagentGuid = System.Guid.NewGuid();
			int reagentTypeId = System.Convert.ToInt16(dtTypes.Rows[0][TABLES.ReagentType.ReagentTypeId]);
			
			DataTable dtTest = SprocHelper.GetInsertReagentSprocTable(reagentGuid, reagentTypeId);
			
			System.Guid [] reagentGuids = new Guid[1];
			reagentGuids[0] = System.Guid.NewGuid();

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.LoginReagent);
			DataTable dtWorkloadEvent = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.LoginReagent, reagentGuids, Common.WorkloadTransactionType.Miscellanious, false);

			bool retValue = DAL.Reagent.InsertReagents(dtTest, dtWorkloadEvent, Common.UpdateFunction.UnitTests);

			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
        [ExpectedException(typeof(Common.UniqueDatabaseConstraintViolatedException))]
		public void InsertReagents_Fail()
		{
            this.RefreshData = true;

            DataTable dtTypes = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM ReagentType", true);

            System.Guid reagentGuid = System.Guid.NewGuid();
            int reagentTypeId = System.Convert.ToInt16(dtTypes.Rows[0][TABLES.ReagentType.ReagentTypeId]);

            DataTable dtTest = SprocHelper.GetInsertReagentSprocTable(reagentGuid, reagentTypeId);

            System.Guid[] reagentGuids = new Guid[1];
            reagentGuids[0] = System.Guid.NewGuid();

            DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.LoginReagent);
            DataTable dtWorkloadEvent = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.LoginReagent, reagentGuids, Common.WorkloadTransactionType.Miscellanious, false);

            bool retValue = DAL.Reagent.InsertReagents(dtTest, dtWorkloadEvent, Common.UpdateFunction.UnitTests);
            retValue = DAL.Reagent.InsertReagents(dtTest, dtWorkloadEvent, Common.UpdateFunction.UnitTests);
		}


		[Test]
		public void UpdateReagent_Pass()
		{
			this.RefreshData = true;
			
			System.Guid reagentGuid = (System.Guid)this._dtReagent.Rows[0][TABLES.Reagent.ReagentGuid];
			byte[] rowVersion = (byte[])this._dtReagent.Rows[0][TABLES.ReagentType.RowVersion];

			DataTable dtUReagent = SprocHelper.GetUpdateReagentSprocTable(reagentGuid, rowVersion);
			DataTable dtIChange = SprocHelper.GetInsertReagentChangeSprocTable(reagentGuid);

			System.Guid [] reagentGuids = new Guid[1];
			reagentGuids[0] = reagentGuid;
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UpdateReagentInventory);
			DataTable dtWorkloadEvents = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.UpdateReagentInventory, reagentGuids, Common.WorkloadTransactionType.Miscellanious, false);

			bool retValue = DAL.Reagent.UpdateReagent(dtUReagent, dtIChange, dtWorkloadEvents, Common.UpdateFunction.UnitTests);

			Assert.AreEqual(true, retValue, "Valid Save");

			retValue = DAL.Reagent.UpdateReagent(new DataTable(), new DataTable(), new DataTable(), Common.UpdateFunction.UnitTests);
			Assert.AreEqual(false, retValue, "Empty Tables");
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void UpdateReagent_Fail()
		{
			System.Guid reagentGuid = (System.Guid)this._dtReagent.Rows[0][TABLES.Reagent.ReagentGuid];
			byte[] rowVersion = new byte[8];

			DataTable dtUReagent = SprocHelper.GetUpdateReagentSprocTable(reagentGuid, rowVersion);
			DataTable dtIChange = SprocHelper.GetInsertReagentChangeSprocTable(reagentGuid);
			System.Guid [] reagentGuids = new Guid[1];
			reagentGuids[0] = reagentGuid;
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.UpdateReagentInventory);
			DataTable dtWorkloadEvents = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.UpdateReagentInventory, reagentGuids, Common.WorkloadTransactionType.Miscellanious, false);
			bool retValue = DAL.Reagent.UpdateReagent(dtUReagent, dtIChange,dtWorkloadEvents, Common.UpdateFunction.UnitTests);
		}

		[Test]
		public void GetReagentTypeStockLevel_Pass()
		{
			int reagentId = System.Convert.ToInt16(this._dtReagent.Rows[0][TABLES.ReagentType.ReagentTypeId]);

			DataTable dtTest = DAL.Reagent.GetReagentTypeStockLevel(reagentId);
			
			Assert.AreEqual(1, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.NumberVialsInStock), ARTIFICIAL.NumberVialsInStock);
        }

		[Test]
		public void GetReagentTypeStockLevel_Fail()
		{
			DataTable dtTest = DAL.Reagent.GetReagentTypeStockLevel(0);
			
			Assert.AreEqual(true , dtTest.Rows[0].IsNull(0), "Null");
		}


		[Test]
		public void GetReagentsByType_Pass()
		{
			int reagentId = System.Convert.ToInt16(this._dtReagent.Rows[0][TABLES.ReagentType.ReagentTypeId]);

			DataTable dtTest = DAL.Reagent.GetReagentsByType(this.TestDivisionCode, reagentId);
			Assert.AreEqual(8, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentGuid), TABLES.Reagent.ReagentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentName), TABLES.Reagent.ReagentName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotNumber), TABLES.Reagent.LotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotExpirationDate), TABLES.Reagent.LotExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.InspectionIndicator), TABLES.Reagent.InspectionIndicator);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentManufacturerName), TABLES.Reagent.ReagentManufacturerName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeId), TABLES.ReagentType.ReagentTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeName), TABLES.ReagentType.ReagentTypeName);

		}

		[Test]
		public void GetReagentsByType_Fail()
		{
			int reagentId = System.Convert.ToInt16(this._dtReagent.Rows[0][TABLES.ReagentType.ReagentTypeId]);

			DataTable dtTest = DAL.Reagent.GetReagentsByType(string.Empty, reagentId);
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}


		[Test]
		public void GetReagentLotsForRetest_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];

			DataTable dtTest = DAL.Reagent.GetReagentLotsForRetest(unitGuid);

			Assert.AreEqual(10, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentGuid), TABLES.Reagent.ReagentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotNumber), TABLES.Reagent.LotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotExpirationDate), TABLES.Reagent.LotExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentTypeId), TABLES.Reagent.ReagentTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.InspectionIndicator), TABLES.Reagent.InspectionIndicator);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeName), TABLES.ReagentType.ReagentTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentManufacturerName), TABLES.Reagent.ReagentManufacturerName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.LastUpdateDate), TABLES.ReagentType.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.TestWithName), TABLES.RackLot.TestWithName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestingMethod.TestingMethodText), TABLES.TestingMethod.TestingMethodText);
		}

		[Test]
		public void GetReagentLotsForRetest_Fail()
		{
			DataTable dtTest = DAL.Reagent.GetReagentLotsForRetest(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetReagentLotsFromPreviousTest_Pass()
		{
			string rackName = this._dtRack.Rows[0][TABLES.Rack.RackName].ToString();

			DataTable dtTest = DAL.Reagent.GetReagentLotsFromPreviousTest(rackName);

			Assert.AreEqual(10, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentGuid), TABLES.Reagent.ReagentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotNumber), TABLES.Reagent.LotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotExpirationDate), TABLES.Reagent.LotExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentTypeId), TABLES.Reagent.ReagentTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.InspectionIndicator), TABLES.Reagent.InspectionIndicator);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeName), TABLES.ReagentType.ReagentTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentManufacturerName), TABLES.Reagent.ReagentManufacturerName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.LastUpdateDate), TABLES.ReagentType.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.TestWithName), TABLES.RackLot.TestWithName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestingMethod.TestingMethodText), TABLES.TestingMethod.TestingMethodText);
		}

		[Test]
		public void GetReagentLotsFromPreviousTest_Fail()
		{
			DataTable dtTest = DAL.Reagent.GetReagentLotsFromPreviousTest(string.Empty);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetReagentFromRack_Pass()
		{
			System.Guid rackGuid = (System.Guid)this._dtRack.Rows[0][TABLES.Rack.RackGuid];
			int reagentId = System.Convert.ToInt16(this._dtReagent.Rows[0][TABLES.ReagentType.ReagentTypeId]);

			DataTable dtTest = DAL.Reagent.GetReagentFromRack(rackGuid, reagentId, this.TestDivisionCode);

			Assert.AreEqual(14, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentGuid), TABLES.Reagent.ReagentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentName), TABLES.Reagent.ReagentName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotNumber), TABLES.Reagent.LotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotExpirationDate), TABLES.Reagent.LotExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeId), TABLES.ReagentType.ReagentTypeId);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.InspectionIndicator), TABLES.Reagent.InspectionIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeName), TABLES.ReagentType.ReagentTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentManufacturerName), TABLES.Reagent.ReagentManufacturerName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.RowVersion), TABLES.ReagentType.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.LastUpdateDate), TABLES.ReagentType.LastUpdateDate);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.TestWithName), TABLES.RackLot.TestWithName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.LotUseDate), TABLES.RackLot.LotUseDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.ReactivityPhaseCode), TABLES.RackLot.ReactivityPhaseCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RackGuid), TABLES.Rack.RackGuid);
		}

		[Test]
		public void GetReagentFromRack_Fail()
		{
			int reagentId = System.Convert.ToInt16(this._dtReagent.Rows[0][TABLES.ReagentType.ReagentTypeId]);

			DataTable dtTest = DAL.Reagent.GetReagentFromRack(System.Guid.NewGuid(), reagentId, this.TestDivisionCode);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetReagentsForInvoice_Pass()
		{
			string invoice = this._dtReagent.Rows[0][TABLES.Reagent.InvoiceNumber].ToString();

			DataTable dtTest = DAL.Reagent.GetReagentsForInvoice(invoice);

			Assert.AreEqual(16, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentGuid), TABLES.Reagent.ReagentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentTypeId), TABLES.Reagent.ReagentTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentName), TABLES.Reagent.ReagentName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReceiptDate), TABLES.Reagent.ReceiptDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReceiptTechId), TABLES.Reagent.ReceiptTechId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.InvoiceNumber), TABLES.Reagent.InvoiceNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotNumber), TABLES.Reagent.LotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotExpirationDate), TABLES.Reagent.LotExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.InspectionIndicator), TABLES.Reagent.InspectionIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.NumberVialsAvailable), TABLES.Reagent.NumberVialsAvailable);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.NumberVialsReceived), TABLES.Reagent.NumberVialsReceived);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.Comments), TABLES.Reagent.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeName), TABLES.ReagentType.ReagentTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTypeParameter.MinimumStockLevel), TABLES.ReagentTypeParameter.MinimumStockLevel);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentManufacturerName), TABLES.Reagent.ReagentManufacturerName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.RowVersion), TABLES.Reagent.RowVersion);
		}

		[Test]
		public void GetReagentsForInvoice_Fail()
		{
			DataTable dtTest = DAL.Reagent.GetReagentsForInvoice(string.Empty);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetReagentByGuid_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtReagent.Rows[0][TABLES.Reagent.ReagentGuid];

			DataTable dtTest = DAL.Reagent.GetReagentByGuid(unitGuid);

			Assert.AreEqual(9, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentGuid), TABLES.Reagent.ReagentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentName), TABLES.Reagent.ReagentName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotNumber), TABLES.Reagent.LotNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotExpirationDate), TABLES.Reagent.LotExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.InspectionIndicator), TABLES.Reagent.InspectionIndicator);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentManufacturerName), TABLES.Reagent.ReagentManufacturerName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeId), TABLES.ReagentType.ReagentTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeName), TABLES.ReagentType.ReagentTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.RowVersion), TABLES.ReagentType.RowVersion);
		}

		[Test]
		public void GetReagentByGuid_Fail()
		{
			DataTable dtTest = DAL.Reagent.GetReagentByGuid(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetPreviousTestingPhases_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtReagent.Rows[0][TABLES.Reagent.ReagentGuid];

			DataTable dtTest = DAL.Reagent.GetPreviousTestingPhases(unitGuid);

			Assert.AreEqual(7, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.RackLotGuid), TABLES.RackLot.RackLotGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.TestWithName), TABLES.RackLot.TestWithName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.ExpectedMinimumReactions), TABLES.RackLot.ExpectedMinimumReactions);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.LotUseDate), TABLES.RackLot.LotUseDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.ReactivityPhaseCode), TABLES.RackLot.ReactivityPhaseCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReactivityPhase.ReactivityPhaseText), TABLES.ReactivityPhase.ReactivityPhaseText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.SatisfactoryResultIndicator), TABLES.RackLot.SatisfactoryResultIndicator);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetPreviousTestingPhases_Fail()
		{
			DataTable dtTest = DAL.Reagent.GetPreviousTestingPhases(System.Guid.Empty);
		}

	}
}
#endif


